### **Introduction to PKI**

- PKI addresses a major challenge in asymmetric encryption and digital certificates: the **secure distribution of public keys**.
- Ensures trust in public keys by binding them to their owners through digital certificates issued by a trusted Certificate Authority (CA).

---

### **Key Concepts of PKI**

#### **1. Role of Certificate Authority (CA)**

- The CA is a trusted entity responsible for:
    - Issuing digital certificates.
    - Signing certificates using its private key to validate the authenticity of the included public key.
- A system will accept a certificate only if it trusts the CA.

---

#### **2. Enrolling into PKI**

- **Step 1: Authenticate the CA**:
    - Each user/system must securely obtain and verify the CA's public key.
    - Often automated for ease (e.g., preinstalled CA certificates in web browsers).
- **Step 2: Generate Key Pairs**:
    - Users generate a private-public key pair and submit their public key with identity information to the CA.
- **Step 3: CA Verifies and Signs**:
    - The CA verifies the user's identity and public key.
    - It signs the user's public key and identity, creating an **identity certificate**.
- **Step 4: Use and Trust**:
    - The signed identity certificate is returned to the user, who installs and uses it for authentication and secure communication.

---

#### **3. Identity Certificates**

- Certificates bind the user's name to their public key.
- Signed by the CA to ensure authenticity and integrity.
- Certificates contain:
    - Public key of the holder.
    - Digital signature of the CA.
    - Information such as serial number, expiration date, algorithms used, and extensions like CRL distribution points.
- Certificates are not secret and do not require encryption.

---

### **PKI Components**

#### **1. CA Certificate**

- A self-signed certificate issued by the CA containing its public key.
- Used by users/entities to verify the CA's signature.

#### **2. X.509 Certificates**

- X.509 is a standard format for certificates and Certificate Revocation Lists (CRLs).
- Widely used in:
    - SSL/TLS for secure web servers and client authentication.
    - S/MIME for secure email.
    - IPsec VPNs for public key distribution.

---

### **Certificate Revocation**

When a private key is compromised, the corresponding certificate must be revoked to prevent misuse. PKI provides two main solutions:

#### **1. Certificate Revocation List (CRL)**

- A time-stamped, CA-signed file containing a list of revoked certificate serial numbers.
- Stored on servers (e.g., HTTP, LDAP, or SCEP-enabled).
- Limitations:
    - CRLs may contain stale information if a key is compromised before the next CRL update.
    - End users must regularly poll the CRL repository to stay updated.

#### **2. Online Certificate Status Protocol (OCSP)**

- A real-time protocol for verifying the revocation status of a certificate.
- Endpoints query the OCSP server to check the validity of a certificate.
- Advantages:
    - Eliminates stale information.
    - Requires a highly available server infrastructure.

|**CRLs**|**OCSP**|
|---|---|
|List of revoked certificates issued periodically|Real-time certificate validation|
|Prone to delays between updates|Immediate updates, reducing attack windows|
|Requires polling by end users|Allows entities to query the OCSP server anytime|

---

### **PKI in Action**

- PKI enables secure communication and authentication in various scenarios:
    - **Web Security**: SSL/TLS uses certificates for secure web server authentication.
    - **Email Security**: S/MIME ensures confidentiality and integrity in email communication.
    - **VPNs**: Certificates are used in IPsec VPNs for RSA-based authentication.

---

### **Key Takeaways**

- PKI ensures **trust** in public keys by binding them to verified identities through certificates.
- The CA plays a central role in issuing and signing certificates.
- Identity certificates, protected by the CA's signature, are essential for secure communication.
- Revocation mechanisms like CRLs and OCSP address key compromise but differ in latency and infrastructure requirements.
- X.509 certificates are the standard for interoperability in secure systems.